# -*- coding: utf-8 -*-
"""
Created on Wed Apr 28 09:51:34 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'Selected files'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================
    
selected_files = ['dyrvik_IGLED19-Batch 17_003C59-normal_6_1.ilv', \
                 'dyrvik_IGLED19-Batch 17_003C5B-normal_6_1.ilv', \
                 'dyrvik_IGLED19-Batch 17_003C5C-rotated_8_2.ilv', \
                 'dyrvik_IGLED19-Batch 22_0040AD-rotated_8_2.ilv']

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Prepare plots"""
label_strings = ['1.6 nm',\
                 '3.3',\
                 '11',\
                 '20']  
    
label_strings_twin = ['1.6',\
                 '3.3',\
                 '11',\
                 '20']  
                                              
colour_array =  np.linspace(0, 999, len(selected_files))

fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax_twin = ax.twinx()
ax.set_xlabel('Bias [V]')
ax.set_ylabel('Current Density [$\mathregular{mA/cm^2}$]')
ax_twin.set_ylabel('Luminance [$\mathregular{cd/m^2}$]')

"""Plot the data"""
for i in range(len(selected_files)):
    """Load data, turn the sign and remove negatives to allow log-plots"""
    file_path = os.path.join(data_folder_path,selected_files[i])
    df = pd.read_csv(file_path, delimiter='\t')
    
    ax.semilogy(df['LED voltage [V]'], df['LED current [mA/cm2]'], color=COLOURS_GREENS[int(colour_array[i])], label=label_strings[i])
    if i == 0:
        ax_twin.semilogy(df['LED voltage [V]'], df['Luminance [cd/m2]'], marker='s', markersize=5*lw, markevery=0.1, color=COLOURS_BLUES[int(colour_array[i])], label=label_strings_twin[i])
    else:
        ax_twin.semilogy(df['LED voltage [V]'], df['Luminance [cd/m2]'], marker='s', markersize=3.5*lw, markevery=0.1, color=COLOURS_BLUES[int(colour_array[i])], label=label_strings_twin[i])


"""Annotation"""
# =============================================================================
# ax.text(0.55, 0.02, 'Without\n$\mathrm{Al_2O_3}$',
#         horizontalalignment='center',
#         verticalalignment='bottom',
#         transform=ax.transAxes)
# =============================================================================

ax.annotate("",
            xy=(0.106, 0.45), xycoords='axes fraction',
            xytext=(0.256, 0.45), textcoords='axes fraction',
            arrowprops=dict(facecolor='black', width=lw),
            )
ax.annotate("",
            xy=(0.473, 0.2), xycoords='axes fraction',
            xytext=(0.323, 0.2), textcoords='axes fraction',
            arrowprops=dict(facecolor='black', width=lw),
            )

"""Axis settings"""
ax.set_xlim(left=2.5)
ax.set_ylim(bottom=8e-4)
ax_twin.set_ylim(bottom=5e-0, top=2e4)
ax.xaxis.set_major_locator(mpl.ticker.MultipleLocator(0.5))
ax.xaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.1))

"""Legend"""
leg = ax.legend(title='Current density',loc='upper left',frameon = False)
leg_twin = ax_twin.legend(title='Luminance',loc='lower right', frameon = False)

# Right-aligning the legend
vp = leg_twin._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax_twin.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_twin.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)


"""Exporting plots"""
export_name = 'Plot'
plot_name = ' JVL TFB thickness no al2o3'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
plt.close(fig)

